package w83b.w83bOperacionesPaso.w83bIncidencias;

import java.io.PrintWriter;
import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bNuevaIncidenciasBean;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bCargaDocOPAction extends Q70ActionPasoOP{

	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		//Guardamos la accion en el contexto
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

	//docs adjuntos
		W83bNuevaIncidenciasBean incidencia=(W83bNuevaIncidenciasBean)contexto.get("w83bNuevaIncidenciasBean");
	
	JSONObject resultado= new JSONObject ();
	JSONArray listaDocs=new JSONArray();
	JSONObject docJSON=null;
	W83bDocBean doc=null;
	for (int i=0;i<incidencia.getListaDocs().size();i++)
	{
		doc=(W83bDocBean)incidencia.getListaDocs().get(i);
		docJSON=new JSONObject();//NOPMD
		docJSON.put("nombreDoc", doc.getNombrePartido());
		docJSON.put("tipoDoc", doc.getTipoDocumento());
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(incidencia.getIdioma()))
		{
			docJSON.put("descTipo", doc.getDescTipo());
			docJSON.put("descTramite", doc.getDescTramite());

		}
		else
		{
			docJSON.put("descTipo", doc.getDeseTipo());
			docJSON.put("descTramite", doc.getDeseTramite());

		}
		docJSON.put("idDoc", doc.getId());
		String numRegistro = "";
		String fechaRegistro = "";
		if(StringUtils.isNotEmpty(doc.getNumeroRegistro())){
			numRegistro = doc.getNumeroRegistro();
		}
		if(StringUtils.isNotEmpty(doc.getFechaRegistro())){
			fechaRegistro = doc.getFechaRegistro();
		}
		docJSON.put("numRegistro", (numRegistro.length()>8)? numRegistro.substring(0, 8) + " " + numRegistro.substring(8, numRegistro.length()):numRegistro);
		docJSON.put("fechaRegistro", fechaRegistro);
		docJSON.put("usuario", doc.getUsuario());
		docJSON.put("codRemesaAcuse", StringUtils.isNotEmpty(doc.getCodRemesaAcuse())?doc.getCodRemesaAcuse():"");
		docJSON.put("codColeccionAcuse", StringUtils.isNotEmpty(doc.getCodColeccionAcuse())?doc.getCodColeccionAcuse():"");
		docJSON.put("codEnvioAcuse",StringUtils.isNotEmpty(doc.getCodEnvioAcuse())?doc.getCodEnvioAcuse():"");
		listaDocs.put(docJSON);

	}
	resultado.put("listaDocs",listaDocs);
	
	incidencia.setListaDocs(new ArrayList());
	
	contexto.set("w83bNuevaIncidenciasBean",incidencia);
	
	resultado.put("resultado", "ok");
	response.setContentType("text/javascript;charset=iso-8859-1");
	response.setHeader("Pragma", "cache");
	response.setHeader("Expires", "0");
	response.setHeader("Cache-Control", "private");
	response.setStatus(HttpServletResponse.SC_OK);
	PrintWriter out = response.getWriter();
	out.print(resultado.toString());
	out.flush();
	
	return null;

		
	}
}
